/************************************************************/
/* PROJECT NAME: AtoD	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin   tmartin@hitex.co.uk             */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM 	V1.3		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example Discrete Fourier Transform						*/
/*															*/
/* Demonstrates Fourier transform					 		*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/

#include "lpc21xx.h"
#include <math.h>
unsigned val = 0;
float REX[256];
float IMX[256];
float MAG[256];
unsigned int I,IP,K,L,N,NM1,ND2,M,J,JM1,LE,LE2,UR,UI;
float TR,TI,SI,SR;
float PI =3.14159265;

int main(void)
{
 
for(I = 1;I<256;I++)
{
REX[I] = 0.5;
IMX[I] = 0;
}


VPBDIV = 0x02;			//Set the Pclk to 30 Mhz
IODIR1 = 0x00FF0000;    // P1.16..23 defined as Outputs  
ADCR   = 0x00270601;    // Setup A/D: 10-bit AIN0 @ 3MHz 
ADCR  |= 0x01000000;    // Start A/D Conversion 

N = 512; 
NM1 = N-1;
ND2 = N/2;
M = 9;
J = ND2;

for( I = 1;I<(N/2);I++)
{

if(I< J)
{
	TR = REX[J];
	TI = IMX[J];
	REX[J] = REX[I];
	IMX[J] = IMX[I];
	REX[I] = TR;
	IMX[I] = TI;
}
K = ND2;
while(K<=J)
{
	J	=J-K;
	K 	= K/2;
}
J = J+K;
}

for(L = 1;L<=M;L++)
{
LE = pow(2,L);
LE2 = LE/2;
UR = 1;
UI = 0;
SR = cos(PI/LE2);
SI = -sin(PI/LE2);
for(J=1;J<=LE2;J++)
{
	JM1 = J-1;
	for(I=JM1;I<NM1;I = I + LE)
	{	
		IP = I+LE2;
		TR = REX[IP]*UR-IMX[IP]*UI;
		TI = REX[IP]*UI+IMX[IP]*UI;
		REX[IP]= REX[I]-TR;
		IMX[IP]= IMX[I]-TI;
		REX[I] = REX[I]+TR;
		IMX[IP]= IMX[I]+TR;
	}
	TR = UR;
	UR = TR*SR-UI*SI;
	UI = TR*SI+UI*SR;

}
}	





/*for (index = 0;index<(N-1);index++)
{ 		  
do
{
    val = ADDR;                   // Read A/D Data Register 
}        
while ((val & 0x80000000) == 0);  //Wait for the conversion to complete
XX[index] =(float) ((val >> 6) & 0x03FF);  //Extract the A/D result 
}
  */

while(1)
{
;
}

}

